package gov.va.med.domain.service.messaging.parse;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Segment;

/**
 * @author Joel Goldberg
 * @version $Id: IHL7ParseEventListener.java,v 1.2 2005/06/20 16:21:18 slava.uchitel Exp $
 * @since MHV 2.0 <br>Jun 20, 2005
 */
public interface IHL7ParseEventListener {
    /*
     * This method is called by parser before processing segment. 
     * Return false to skip segment parsing, true to continue 
     * parsing. In implementation might be used to skip segments that
     * do not carry information of interest to save memory ans 
     * processing time/power.
     */ 
    public boolean onSegmentStart(String segName);
    
    /*
     *This method is called after parser parsed segment. Gives implementor chance to
     * better filter parsing in following segments based on data in parsed segment. 
     */
    public void onSegmentEnd(String segName, Segment seg) throws HL7Exception;

}
